/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.di.ytilib;

import java.util.Arrays;
import java.util.List;
import ru.autosome.assist.AMatrix;
import ru.autosome.di.ytilib.Din;
import ru.autosome.di.ytilib.Sequence;

public class WPCM
extends AMatrix {
    public static final double KDIDIC_MAX = -Math.log(0.0625);

    public WPCM(int length, Sequence seq, int pos) {
        this.N = 1.0;
        this.matrix = new double[Din.dins][length];
        for (int i = 0; i < length; ++i) {
            this.matrix[seq.direct()[pos + i]][i] = this.N;
        }
        this.length = length;
    }

    public WPCM(int length, List<Integer>[] prihits, List<Integer>[] revhits, Sequence[] sequences, List<Integer> sequenceOrder, int sequenceCount) {
        int i;
        this.length = length;
        double totalWeight = 0.0;
        for (i = 0; i < sequenceCount; ++i) {
            totalWeight += sequences[sequenceOrder.get((int)i).intValue()].weight;
        }
        this.N = totalWeight;
        this.matrix = new double[Din.dins][];
        for (i = 0; i < Din.dins; ++i) {
            this.matrix[i] = new double[length];
        }
        for (i = 0; i < sequenceCount; ++i) {
            int j;
            int k = sequenceOrder.get(i);
            Sequence sequence = sequences[k];
            double hitWeight = sequence.weight / (double)(prihits[k].size() + revhits[k].size());
            for (Integer prihit : prihits[k]) {
                j = 0;
                while (j < length) {
                    double[] dArray = this.matrix[sequence.direct()[prihit + j]];
                    int n = j++;
                    dArray[n] = dArray[n] + hitWeight;
                }
            }
            for (Integer revhit : revhits[k]) {
                j = 0;
                while (j < length) {
                    double[] dArray = this.matrix[sequence.revcomp()[revhit + j]];
                    int n = j++;
                    dArray[n] = dArray[n] + hitWeight;
                }
            }
        }
        this.processNs();
    }

    public WPCM(double n, double[][] matrix) {
        this.length = matrix[0].length;
        this.N = n;
        this.matrix = matrix;
    }

    public WPCM(double n, double[][] matrix, boolean processIUPAC) {
        this(n, matrix);
        if (processIUPAC) {
            this.processNs();
        }
    }

    public WPCM(WPCM base) {
        this.matrix = new double[base.matrix.length][];
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i] = (double[])base.matrix[i].clone();
        }
        this.length = base.length;
        this.N = base.N;
    }

    public static void iupacomprobs(double[] probs) {
        probs[(byte)Din.NN.ordinal()] = 0.0625;
        WPCM.fillProb(Din.AN, probs, Din.AA, Din.AC, Din.AG, Din.AT);
        WPCM.fillProb(Din.CN, probs, Din.CA, Din.CC, Din.CG, Din.CT);
        WPCM.fillProb(Din.GN, probs, Din.GA, Din.GC, Din.GG, Din.GT);
        WPCM.fillProb(Din.TN, probs, Din.TA, Din.TC, Din.TG, Din.TT);
        WPCM.fillProb(Din.NA, probs, Din.AA, Din.CA, Din.GA, Din.TA);
        WPCM.fillProb(Din.NC, probs, Din.AC, Din.CC, Din.GC, Din.TC);
        WPCM.fillProb(Din.NG, probs, Din.AG, Din.CG, Din.GG, Din.TG);
        WPCM.fillProb(Din.NT, probs, Din.AT, Din.CT, Din.GT, Din.TT);
    }

    private static void fillProb(Din what, double[] probs, Din w1, Din w2, Din w3, Din w4) {
        probs[(byte)what.ordinal()] = (probs[(byte)w1.ordinal()] + probs[(byte)w2.ordinal()] + probs[(byte)w3.ordinal()] + probs[(byte)w4.ordinal()]) / 4.0;
    }

    public WPCM(Integer length, List<Integer>[] prihits, List<Integer>[] revhits, Sequence[] sequences, boolean discardWeights) {
        this.length = length;
        this.N = sequences.length;
        this.matrix = new double[Din.dins][];
        for (int i = 0; i < Din.dins; ++i) {
            this.matrix[i] = new double[length.intValue()];
        }
        for (int k = 0; k < sequences.length; ++k) {
            int j;
            Sequence sequence = sequences[k];
            double total_weight = (discardWeights ? 1.0 : sequence.weight) / (double)(prihits[k].size() + revhits[k].size());
            for (Integer prihit : prihits[k]) {
                j = 0;
                while (j < length) {
                    double[] dArray = this.matrix[sequence.direct()[prihit + j]];
                    int n = j++;
                    dArray[n] = dArray[n] + total_weight;
                }
            }
            for (Integer revhit : revhits[k]) {
                j = 0;
                while (j < length) {
                    double[] dArray = this.matrix[sequence.revcomp()[revhit + j]];
                    int n = j++;
                    dArray[n] = dArray[n] + total_weight;
                }
            }
        }
        this.processNs();
    }

    public WPCM(int length, List<Integer>[] prihits, List<Integer>[] revhits, Sequence[] sequences) {
        this.length = length;
        this.N = sequences.length;
        this.matrix = new double[Din.dins][];
        for (int i = 0; i < Din.dins; ++i) {
            this.matrix[i] = new double[length];
        }
        for (int k = 0; k < sequences.length; ++k) {
            int j;
            Sequence sequence = sequences[k];
            double total_weight = sequence.weight / (double)(prihits[k].size() + revhits[k].size());
            for (Integer prihit : prihits[k]) {
                j = 0;
                while (j < length) {
                    double[] dArray = this.matrix[sequence.direct()[prihit + j]];
                    int n = j++;
                    dArray[n] = dArray[n] + total_weight;
                }
            }
            for (Integer revhit : revhits[k]) {
                j = 0;
                while (j < length) {
                    double[] dArray = this.matrix[sequence.revcomp()[revhit + j]];
                    int n = j++;
                    dArray[n] = dArray[n] + total_weight;
                }
            }
        }
        this.processNs();
    }

    public WPCM(byte[][] alignment) {
        this.N = alignment.length;
        this.length = alignment[0].length;
        this.matrix = new double[Din.dins][];
        for (int i = 0; i < Din.dins; ++i) {
            this.matrix[i] = new double[this.length];
        }
        for (byte[] word : alignment) {
            int j = 0;
            while (j < this.length) {
                double[] dArray = this.matrix[word[j]];
                int n = j++;
                dArray[n] = dArray[n] + 1.0;
            }
        }
        this.processNs();
    }

    public WPCM toPWM(double[] background) {
        double pseudocount = this.N == 1.0 ? Math.log(2.0) : Math.log(this.N);
        for (int j = 0; j < this.length; ++j) {
            for (int i = 0; i < Din.dins; ++i) {
                this.matrix[i][j] = Math.log((this.matrix[i][j] + background[i] * pseudocount) / ((this.N + pseudocount) * background[i]));
            }
        }
        return this;
    }

    public void rebuild(List<Integer>[] prihits, List<Integer>[] revhits, Sequence[] sequences) {
        for (int i = 0; i < Din.dins; ++i) {
            Arrays.fill(this.matrix[i], 0.0);
        }
        for (int k = 0; k < sequences.length; ++k) {
            Sequence sequence = sequences[k];
            sequence.rebuild(this, prihits[k], revhits[k]);
        }
        this.processNs();
    }

    private void processNs() {
        int j;
        for (j = 0; j < this.length; ++j) {
            double NA = this.matrix[(byte)Din.NA.ordinal()][j] / 4.0;
            double[] dArray = this.matrix[(byte)Din.AA.ordinal()];
            int n = j;
            dArray[n] = dArray[n] + NA;
            double[] dArray2 = this.matrix[(byte)Din.CA.ordinal()];
            int n2 = j;
            dArray2[n2] = dArray2[n2] + NA;
            double[] dArray3 = this.matrix[(byte)Din.GA.ordinal()];
            int n3 = j;
            dArray3[n3] = dArray3[n3] + NA;
            double[] dArray4 = this.matrix[(byte)Din.TA.ordinal()];
            int n4 = j;
            dArray4[n4] = dArray4[n4] + NA;
            double NC = this.matrix[(byte)Din.NC.ordinal()][j] / 4.0;
            double[] dArray5 = this.matrix[(byte)Din.AC.ordinal()];
            int n5 = j;
            dArray5[n5] = dArray5[n5] + NC;
            double[] dArray6 = this.matrix[(byte)Din.CC.ordinal()];
            int n6 = j;
            dArray6[n6] = dArray6[n6] + NC;
            double[] dArray7 = this.matrix[(byte)Din.GC.ordinal()];
            int n7 = j;
            dArray7[n7] = dArray7[n7] + NC;
            double[] dArray8 = this.matrix[(byte)Din.TC.ordinal()];
            int n8 = j;
            dArray8[n8] = dArray8[n8] + NC;
            double NG = this.matrix[(byte)Din.NG.ordinal()][j] / 4.0;
            double[] dArray9 = this.matrix[(byte)Din.AG.ordinal()];
            int n9 = j;
            dArray9[n9] = dArray9[n9] + NG;
            double[] dArray10 = this.matrix[(byte)Din.CG.ordinal()];
            int n10 = j;
            dArray10[n10] = dArray10[n10] + NG;
            double[] dArray11 = this.matrix[(byte)Din.GG.ordinal()];
            int n11 = j;
            dArray11[n11] = dArray11[n11] + NG;
            double[] dArray12 = this.matrix[(byte)Din.TG.ordinal()];
            int n12 = j;
            dArray12[n12] = dArray12[n12] + NG;
            double NT = this.matrix[(byte)Din.NT.ordinal()][j] / 4.0;
            double[] dArray13 = this.matrix[(byte)Din.AT.ordinal()];
            int n13 = j;
            dArray13[n13] = dArray13[n13] + NT;
            double[] dArray14 = this.matrix[(byte)Din.CT.ordinal()];
            int n14 = j;
            dArray14[n14] = dArray14[n14] + NT;
            double[] dArray15 = this.matrix[(byte)Din.GT.ordinal()];
            int n15 = j;
            dArray15[n15] = dArray15[n15] + NT;
            double[] dArray16 = this.matrix[(byte)Din.TT.ordinal()];
            int n16 = j;
            dArray16[n16] = dArray16[n16] + NT;
            double AN = this.matrix[(byte)Din.AN.ordinal()][j] / 4.0;
            double[] dArray17 = this.matrix[(byte)Din.AA.ordinal()];
            int n17 = j;
            dArray17[n17] = dArray17[n17] + AN;
            double[] dArray18 = this.matrix[(byte)Din.AC.ordinal()];
            int n18 = j;
            dArray18[n18] = dArray18[n18] + AN;
            double[] dArray19 = this.matrix[(byte)Din.AG.ordinal()];
            int n19 = j;
            dArray19[n19] = dArray19[n19] + AN;
            double[] dArray20 = this.matrix[(byte)Din.AT.ordinal()];
            int n20 = j;
            dArray20[n20] = dArray20[n20] + AN;
            double CN = this.matrix[(byte)Din.CN.ordinal()][j] / 4.0;
            double[] dArray21 = this.matrix[(byte)Din.CA.ordinal()];
            int n21 = j;
            dArray21[n21] = dArray21[n21] + CN;
            double[] dArray22 = this.matrix[(byte)Din.CC.ordinal()];
            int n22 = j;
            dArray22[n22] = dArray22[n22] + CN;
            double[] dArray23 = this.matrix[(byte)Din.CG.ordinal()];
            int n23 = j;
            dArray23[n23] = dArray23[n23] + CN;
            double[] dArray24 = this.matrix[(byte)Din.CT.ordinal()];
            int n24 = j;
            dArray24[n24] = dArray24[n24] + CN;
            double GN = this.matrix[(byte)Din.GN.ordinal()][j] / 4.0;
            double[] dArray25 = this.matrix[(byte)Din.GA.ordinal()];
            int n25 = j;
            dArray25[n25] = dArray25[n25] + GN;
            double[] dArray26 = this.matrix[(byte)Din.GC.ordinal()];
            int n26 = j;
            dArray26[n26] = dArray26[n26] + GN;
            double[] dArray27 = this.matrix[(byte)Din.GG.ordinal()];
            int n27 = j;
            dArray27[n27] = dArray27[n27] + GN;
            double[] dArray28 = this.matrix[(byte)Din.GT.ordinal()];
            int n28 = j;
            dArray28[n28] = dArray28[n28] + GN;
            double TN = this.matrix[(byte)Din.TN.ordinal()][j] / 4.0;
            double[] dArray29 = this.matrix[(byte)Din.TA.ordinal()];
            int n29 = j;
            dArray29[n29] = dArray29[n29] + TN;
            double[] dArray30 = this.matrix[(byte)Din.TC.ordinal()];
            int n30 = j;
            dArray30[n30] = dArray30[n30] + TN;
            double[] dArray31 = this.matrix[(byte)Din.TG.ordinal()];
            int n31 = j;
            dArray31[n31] = dArray31[n31] + TN;
            double[] dArray32 = this.matrix[(byte)Din.TT.ordinal()];
            int n32 = j;
            dArray32[n32] = dArray32[n32] + TN;
            double NN = this.matrix[(byte)Din.NN.ordinal()][j] / 16.0;
            for (byte b = (byte)Din.AA.ordinal(); b <= (byte)Din.TT.ordinal(); b = (byte)(b + 1)) {
                double[] dArray33 = this.matrix[b];
                int n33 = j;
                dArray33[n33] = dArray33[n33] + NN;
            }
        }
        for (j = 0; j < this.length; ++j) {
            this.matrix[(byte)Din.NN.ordinal()][j] = this.N / 16.0;
            this.fillMatrix(j, Din.AN, this.matrix, Din.AA, Din.AC, Din.AG, Din.AT);
            this.fillMatrix(j, Din.CN, this.matrix, Din.CA, Din.CC, Din.CG, Din.CT);
            this.fillMatrix(j, Din.GN, this.matrix, Din.GA, Din.GC, Din.GG, Din.GT);
            this.fillMatrix(j, Din.TN, this.matrix, Din.TA, Din.TC, Din.TG, Din.TT);
            this.fillMatrix(j, Din.NA, this.matrix, Din.AA, Din.CA, Din.GA, Din.TA);
            this.fillMatrix(j, Din.NC, this.matrix, Din.AC, Din.CC, Din.GC, Din.TC);
            this.fillMatrix(j, Din.NG, this.matrix, Din.AG, Din.CG, Din.GG, Din.TG);
            this.fillMatrix(j, Din.NT, this.matrix, Din.AT, Din.CT, Din.GT, Din.TT);
        }
    }

    private void fillMatrix(int j, Din what, double[][] matrix, Din w1, Din w2, Din w3, Din w4) {
        matrix[(byte)what.ordinal()][j] = (matrix[(byte)w1.ordinal()][j] + matrix[(byte)w2.ordinal()][j] + matrix[(byte)w3.ordinal()][j] + matrix[(byte)w4.ordinal()][j]) / 4.0;
    }

    public double kdidic(double[] background, int j) {
        double kdidic = WPCM.logFact(this.N);
        for (int i = 0; i <= 15; ++i) {
            kdidic -= WPCM.logFact(this.matrix[i][j]);
            kdidic += this.matrix[i][j] * Math.log(background[i]);
        }
        kdidic = -kdidic / this.N;
        return kdidic / KDIDIC_MAX;
    }

    public double kdidic(double[] background) {
        double kdidic = 0.0;
        for (int j = 0; j < this.length; ++j) {
            kdidic += this.kdidic(background, j);
        }
        return kdidic / (double)this.length;
    }

    public double thresholdLC() {
        double[] vs;
        double r = WPCM.logFact(this.N);
        double o = this.N / 14.0;
        for (double v : vs = new double[]{o, o, o, o, o, o, o, o, o, o, o, o, o, o, 0.0, 0.0}) {
            r -= WPCM.logFact(v);
            r += v * Math.log(0.0625);
        }
        double threshold = -r / this.N;
        return threshold / KDIDIC_MAX;
    }

    public WPCM toPWM(double pseudocount, double[] background) {
        for (int j = 0; j < this.length; ++j) {
            for (int i = 0; i < Din.dins; ++i) {
                this.matrix[i][j] = Math.log((this.matrix[i][j] + background[i] * pseudocount) / ((this.N + pseudocount) * background[i]));
            }
        }
        return this;
    }

    @Override
    public AMatrix makePWM(double[] background) {
        return new WPCM(this).toPWM(background);
    }
}

