/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.di;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import ru.autosome.ChIPApp;
import ru.autosome.assist.AShapeProvider;
import ru.autosome.assist.Conductor;
import ru.autosome.assist.Helpers;
import ru.autosome.assist.Occurrence;
import ru.autosome.di.engine.DoptiStep;
import ru.autosome.di.engine.Task;
import ru.autosome.di.ytilib.Din;
import ru.autosome.di.ytilib.MunkResult;
import ru.autosome.di.ytilib.Peak;
import ru.autosome.di.ytilib.RNASequence;
import ru.autosome.di.ytilib.SeedCask;
import ru.autosome.di.ytilib.Sequence;
import ru.autosome.di.ytilib.WPCM;

public class ChIPAct
extends ChIPApp {
    private int threadCount;
    private int iterationLimit;
    private int stepLimit;
    private int tryLimit;
    private SeedCask seeds;
    private WPCM best;
    private double bestInfocod;
    private Integer motifLength;
    protected List<Sequence[]> sequenceSets;
    protected Sequence[] joinedSets;
    protected double[] background = Sequence.uniformBackground;
    private WPCM result = null;
    private double[] shape;

    @Override
    public WPCM getResult() {
        return this.result;
    }

    public synchronized WPCM getBest() {
        return new WPCM(this.best);
    }

    public synchronized double getBestInfocod() {
        return this.bestInfocod;
    }

    public synchronized void checkBest(WPCM pm) {
        double newicd = pm.kdidic(this.background);
        if (newicd > this.bestInfocod) {
            this.conductor.message("found new GMLA with higher KDIDIC " + newicd + " > " + this.bestInfocod);
            this.best = pm;
            this.bestInfocod = this.best.kdidic(this.background);
        }
    }

    public static void main(String[] args) {
        ChIPAct chipstep = new ChIPAct(args, Conductor.defaultConductor);
        chipstep.verbose = true;
        chipstep.launchViaConductor();
    }

    public ChIPAct(String[] args, Conductor conductor) {
        this(args, conductor, null, null);
    }

    public ChIPAct(String[] args, Conductor conductor, ChIPApp.PreprocessMode preprocessMode, List<MunkResult> preprocessList) {
        super(conductor);
        conductor.setTotalTicks(9);
        conductor.message("ru.autosome.di.ChIPAct engine usage: <length> <s:simple_set> <o:ordered_set> <w:weighted_set> <p:peak_set> <m:summit_set> <r:rna_set> [<try_limit>=200] [<step_limit>=20>] [<iter_limit>=1] [<thread_count>=2] [<seeds_set>=random|filename.mfa] [<background>=uniform|auto/local] [<motif_shape>=flat|single|double] [<disable_log_weighting>]");
        if (args.length < 2) {
            throw new RuntimeException("not enough parameters");
        }
        int setsCount = 0;
        for (String arg : args) {
            if (arg.length() <= 1 || arg.charAt(1) != ':') continue;
            ++setsCount;
        }
        if (setsCount == 0) {
            throw new RuntimeException("no input dataset found");
        }
        this.motifLength = new Integer(args[0]);
        if (this.motifLength < 1) {
            throw new RuntimeException("too small motif length");
        }
        this.threadCount = args.length - setsCount > 4 ? new Integer(args[setsCount + 4]) : 2;
        this.iterationLimit = args.length - setsCount > 3 ? new Integer(args[setsCount + 3]) : 1;
        this.stepLimit = args.length - setsCount > 2 ? new Integer(args[setsCount + 2]) : 20;
        this.tryLimit = args.length - setsCount > 1 ? new Integer(args[setsCount + 1]) : 200;
        boolean logWeighting = args.length <= setsCount + 8;
        this.sequenceSets = new ArrayList<Sequence[]>();
        ArrayList<Peak> allPeaks = new ArrayList<Peak>();
        for (int i = 1; i <= setsCount; ++i) {
            String argsi = args[i].toLowerCase();
            ChIPApp.SetType setype = argsi.startsWith("o:") ? ChIPApp.SetType.ORDERED : (argsi.startsWith("w:") ? ChIPApp.SetType.WEIGHTED : (argsi.startsWith("p:") ? ChIPApp.SetType.PEAK : (argsi.startsWith("r:") ? ChIPApp.SetType.RNA : (argsi.startsWith("m:") ? ChIPApp.SetType.MIDPOINT : (argsi.startsWith("i:") ? ChIPApp.SetType.RNAMIDPOINT : (argsi.startsWith("s:") ? ChIPApp.SetType.SIMPLE : ChIPApp.SetType.UNKNOWN))))));
            Sequence[] nset = null;
            switch (setype) {
                case WEIGHTED: {
                    nset = ChIPAct.loadWeighted(args[i].substring(2), this.motifLength + 1);
                    break;
                }
                case ORDERED: {
                    nset = ChIPAct.loadSequences(args[i].substring(2), this.motifLength + 1);
                    for (int j = 0; j < nset.length; ++j) {
                        nset[j].weight = 1.0 / (double)(j + 1);
                    }
                    break;
                }
                case SIMPLE: {
                    nset = ChIPAct.loadSequences(args[i].substring(2), this.motifLength + 1);
                    break;
                }
                case PEAK: {
                    nset = ChIPAct.loadPeaks(args[i].substring(2), this.motifLength + 1);
                    for (Peak wp : (Peak[])nset) {
                        wp.soften(this.motifLength);
                        wp.normalize(logWeighting);
                    }
                    allPeaks.addAll(Arrays.asList((Peak[])nset));
                    break;
                }
                case RNA: {
                    nset = ChIPAct.loadRNA(args[i].substring(2), this.motifLength + 1);
                    break;
                }
                case MIDPOINT: {
                    nset = ChIPAct.loadMidpoint(args[i].substring(2), this.motifLength + 1, false);
                    for (Peak wp : (Peak[])nset) {
                        wp.soften(this.motifLength);
                    }
                    allPeaks.addAll(Arrays.asList((Peak[])nset));
                    break;
                }
                case RNAMIDPOINT: {
                    nset = ChIPAct.loadMidpoint(args[i].substring(2), this.motifLength + 1, true);
                    for (Peak wp : (Peak[])nset) {
                        wp.soften(this.motifLength);
                    }
                    allPeaks.addAll(Arrays.asList((Peak[])nset));
                    break;
                }
                case UNKNOWN: {
                    throw new RuntimeException("unknown sequence set mode detected");
                }
            }
            this.sequenceSets.add(nset);
        }
        if (args.length > setsCount + 7) {
            this.shape = args[setsCount + 7].startsWith("s") ? AShapeProvider.SingleBox.shape(this.motifLength) : (double[])(args[setsCount + 7].startsWith("d") ? AShapeProvider.DoubleBox.shape(this.motifLength) : null);
        }
        this.makeJoinedSets(preprocessMode, preprocessList, logWeighting);
        if (this.joinedSets == null || this.joinedSets.length == 0) {
            throw new RuntimeException("empty sequence set: everything is filtered out or sequences are shorter than the requested motif length");
        }
        if (args.length > setsCount + 6) {
            if (args[setsCount + 6].equals("auto") || args[setsCount + 6].equals("local")) {
                this.background = Sequence.background(this.joinedSets);
            } else if (!args[setsCount + 6].equals("uniform")) {
                throw new UnsupportedOperationException("unsupported background: " + args[setsCount + 6]);
            }
        }
        conductor.message("gathering seeds...");
        this.seeds = new SeedCask(this.tryLimit, this.motifLength);
        if (args.length > setsCount + 5 && !args[setsCount + 5].toLowerCase().equals("random")) {
            if (args[setsCount + 5].toLowerCase().equals("peak")) {
                if (allPeaks.size() == 0) {
                    throw new RuntimeException("no peak data found");
                }
                Peak[] peaks = allPeaks.toArray(new Peak[allPeaks.size()]);
                Arrays.sort(peaks, new Comparator<Peak>(){

                    @Override
                    public int compare(Peak o1, Peak o2) {
                        return Double.valueOf(o2.weight).compareTo(o1.weight);
                    }
                });
                this.seeds.fromPeaks(peaks);
            } else {
                this.seeds.fromSequences(ChIPAct.loadSequences(args[setsCount + 5], this.motifLength));
            }
        }
        conductor.message("gathered " + this.seeds.count() + " seeds");
    }

    private static Sequence[] loadMidpoint(String filename, Integer minLength, boolean rnaMode) {
        ArrayList<RNASequence> resa = new ArrayList<RNASequence>();
        try {
            String s;
            BufferedReader bin = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
            StringBuilder sb = new StringBuilder();
            int[] profile = null;
            while ((s = bin.readLine()) != null) {
                if (s.length() != 0 && s.charAt(0) == '>') {
                    String[] pivis = s.substring(1).trim().split(" ");
                    if (sb.length() >= minLength) {
                        if (profile.length > 1) {
                            throw new IOException("more than one middlepoint-summit position given in the fasta header");
                        }
                        double[] triangleProfile = Helpers.makeTriangleProfile(sb.length(), profile[0]);
                        resa.add((RNASequence)(rnaMode ? new RNASequence(sb.toString(), triangleProfile) : new Peak(sb.toString(), triangleProfile)));
                    }
                    sb.setLength(0);
                    profile = new int[pivis.length];
                    for (int i = 0; i < pivis.length; ++i) {
                        profile[i] = Integer.parseInt(pivis[i]);
                    }
                    continue;
                }
                sb.append(s.trim());
            }
            if (sb.length() >= minLength) {
                if (profile.length > 1) {
                    throw new IOException("more than one middlepoint-summit position given in the fasta header");
                }
                double[] triangleProfile = Helpers.makeTriangleProfile(sb.length(), (int)profile[0]);
                resa.add((RNASequence)(rnaMode ? new RNASequence(sb.toString(), triangleProfile) : new Peak(sb.toString(), triangleProfile)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("unable to parse the sequences file " + filename);
        }
        Peak[] res = new Peak[resa.size()];
        return resa.toArray(res);
    }

    private static Sequence[] loadRNA(String filename, Integer minLength) {
        ArrayList<RNASequence> resa = new ArrayList<RNASequence>();
        try {
            String s;
            BufferedReader bin = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
            StringBuilder sb = new StringBuilder();
            while ((s = bin.readLine()) != null) {
                if (s.length() > 0 && s.charAt(0) == '>') {
                    if (sb.length() >= minLength) {
                        resa.add(new RNASequence(sb.toString()));
                    }
                    sb.setLength(0);
                    continue;
                }
                sb.append(s);
            }
            if (sb.length() >= minLength) {
                resa.add(new RNASequence(sb.toString()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("unable to parse input sequences file " + filename);
        }
        Sequence[] res = new Sequence[resa.size()];
        return resa.toArray(res);
    }

    private void makeJoinedSets(ChIPApp.PreprocessMode preprocessMode, List<MunkResult> preprocessList, boolean logWeighting) {
        int totalWeight = ChIPAct.countSequences(this.sequenceSets);
        List<Sequence[]> preprocessedSets = null;
        if (preprocessMode != null && preprocessList == null) {
            throw new RuntimeException("preprocess mode is defined, but preprocess list is undefined; unknown error");
        }
        if (preprocessMode == null || preprocessList.size() == 0 || preprocessMode == ChIPApp.PreprocessMode.DUMMY) {
            preprocessedSets = this.sequenceSets;
        } else if (preprocessMode == ChIPApp.PreprocessMode.MASK) {
            preprocessedSets = this.preprocessMask(preprocessList);
        } else if (preprocessMode == ChIPApp.PreprocessMode.FILTER) {
            this.conductor.message("sequence sets before filtering: " + this.sequenceSets.size());
            preprocessedSets = this.preprocessFilter(preprocessList);
            this.conductor.message("sequence sets after filtering: " + preprocessedSets.size());
            totalWeight = ChIPAct.countSequences(preprocessedSets);
        }
        if (preprocessedSets.size() == 0) {
            return;
        }
        ArrayList<Double> setWeights = new ArrayList<Double>();
        if (logWeighting) {
            this.conductor.message("using logarithmic sets weighting");
            double sumW = 0.0;
            for (int i = 0; i < preprocessedSets.size(); ++i) {
                Sequence[] preprocessedSet = preprocessedSets.get(i);
                setWeights.add(Math.log(preprocessedSet.length + 1));
                sumW += ((Double)setWeights.get(i)).doubleValue();
            }
            double koeff = (double)totalWeight / sumW;
            for (int i = 0; i < preprocessedSets.size(); ++i) {
                setWeights.set(i, (Double)setWeights.get(i) * koeff);
            }
        } else {
            int i;
            double effSize = 0.0;
            for (i = 0; i < preprocessedSets.size(); ++i) {
                effSize += preprocessedSets.get(i).length > 0 ? 1.0 : 0.0;
            }
            for (i = 0; i < preprocessedSets.size(); ++i) {
                setWeights.add((double)totalWeight / effSize);
            }
        }
        for (int i = 0; i < preprocessedSets.size(); ++i) {
            Sequence[] sequenceSet = preprocessedSets.get(i);
            ChIPAct.normalizeWeights(sequenceSet, (Double)setWeights.get(i));
        }
        this.joinedSets = ChIPAct.joinSeqsa(totalWeight, preprocessedSets);
        this.conductor.message("using " + this.joinedSets.length + " sequences");
    }

    public ChIPAct(Parameters parameters) {
        super(parameters.getConductor());
        this.conductor.setTotalTicks(9);
        this.motifLength = parameters.getMotifLength();
        if (this.motifLength < 1) {
            throw new RuntimeException("too small motif length");
        }
        this.threadCount = parameters.getThreadCount();
        this.iterationLimit = parameters.getIterationLimit();
        this.stepLimit = parameters.getStepLimit();
        this.tryLimit = parameters.getTryLimit();
        this.shape = parameters.getShape();
        if (parameters.isLocalBackground()) {
            this.background = Sequence.background(this.joinedSets);
        }
        this.sequenceSets = parameters.getSequenceSets();
        this.prepareSets(parameters.isLogWeighting());
        this.makeJoinedSets(parameters.getPreprocessMode(), parameters.getPreprocessList(), parameters.isLogWeighting());
        if (this.joinedSets == null || this.joinedSets.length == 0) {
            throw new RuntimeException("empty sequence set: everything is filtered out or sequences are shorter than the requested motif length");
        }
        this.conductor.message("gathering seeds...");
        this.seeds = new SeedCask(this.tryLimit, this.motifLength);
        this.conductor.message("gathered " + this.seeds.count() + " seeds");
    }

    private void prepareSets(boolean logWeighting) {
        ArrayList<Sequence[]> result = new ArrayList<Sequence[]>(this.sequenceSets.size());
        for (int i = 0; i < this.sequenceSets.size(); ++i) {
            Sequence[] set;
            ArrayList<Sequence> filtered = new ArrayList<Sequence>();
            Sequence[] sequenceArray = set = this.sequenceSets.get(i);
            int n = sequenceArray.length;
            for (int j = 0; j < n; ++j) {
                Sequence seq = sequenceArray[j];
                if (seq.weight <= 0.0) {
                    throw new RuntimeException("found a sequence with zero weight");
                }
                if (seq.getDirect().length != seq.getRevcomp().length) {
                    throw new RuntimeException("internal error: found a sequence with different direct and reverse complementary strand lengths");
                }
                if (seq.getDirect().length < 2) {
                    throw new RuntimeException("found too short sequence of length " + seq.getDirect().length);
                }
                if (seq.getDirect().length < this.motifLength) continue;
                filtered.add(seq.copy());
            }
            Sequence[] resf = filtered.toArray(new Sequence[filtered.size()]);
            if (resf.length <= 0) continue;
            result.add(resf);
        }
        if (result.size() == 0) {
            throw new RuntimeException("found no suitable sequences for the selected motif length " + this.motifLength);
        }
        this.sequenceSets = result;
        for (Sequence[] seqs : this.sequenceSets) {
            for (Sequence seq : seqs) {
                if (seq.getClass() != Peak.class) continue;
                Peak peak = (Peak)seq;
                peak.soften(this.motifLength);
                peak.normalize(logWeighting);
            }
        }
    }

    @Override
    public WPCM launch() {
        WPCM seed;
        if (this.joinedSets == null) {
            throw new RuntimeException("no sequence data present (possibly everything filtered out)");
        }
        ExecutorService threadPool = Executors.newFixedThreadPool(this.threadCount, this.conductor.getThreadFactory());
        Future<WPCM> lastTaskRes = null;
        double complete = 0.1;
        while ((seed = this.seeds.seed()) != null) {
            Task task = new Task(new DoptiStep(this.joinedSets, Math.sqrt(this.joinedSets.length), seed, this, this.stepLimit, this.iterationLimit, this.background, this.shape), this);
            double x = 1.0 - ((double)this.seeds.size() + 1.0) / (double)this.tryLimit;
            if (x >= complete) {
                complete += 0.1;
                task.setMessage("motif discovery, length " + this.motifLength + ": " + Math.floor((double)Math.round(x * 10.0) * 10.0) + "% complete");
            }
            lastTaskRes = threadPool.submit(task);
        }
        threadPool.shutdown();
        try {
            threadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.conductor.output("OUTC", "ru.autosome.di.ChIPAct");
        if (this.best != null) {
            this.conductor.message("success; best KDIDIC " + this.best.kdidic(this.background));
            this.conductor.output("DIAG", "gapless multiple local alignment of length " + this.best.length());
            this.conductor.output("KDDC", this.best.kdidic(this.background));
            if (this.verbose.booleanValue()) {
                ChIPAct.prettyOutputWPCM(this.conductor, this.best.getMatrix());
            }
        } else {
            try {
                lastTaskRes.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.result = this.best;
        this.conductor.setStatus(this.result != null ? Conductor.Status.SUCCESS : Conductor.Status.FAIL);
        return this.result;
    }

    public static void normalizeWeights(Sequence[] sequenceSet, double v) {
        double weightSum = 0.0;
        for (Sequence sequence : sequenceSet) {
            if (sequence.weight <= 0.0) {
                throw new RuntimeException("found sequence with the zero weight or peak height");
            }
            weightSum += sequence.weight;
        }
        double koeff = v / weightSum;
        for (Sequence sequence : sequenceSet) {
            sequence.weight *= koeff;
        }
    }

    public static Sequence[] loadSequences(String filename, int minLength) {
        ArrayList<Sequence> resa = new ArrayList<Sequence>();
        try {
            String s;
            BufferedReader bin = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
            StringBuilder sb = new StringBuilder();
            while ((s = bin.readLine()) != null) {
                if (s.length() > 0 && s.charAt(0) == '>') {
                    if (sb.length() >= minLength) {
                        resa.add(new Sequence(sb.toString()));
                    }
                    sb.setLength(0);
                    continue;
                }
                sb.append(s.trim());
            }
            if (sb.length() >= minLength) {
                resa.add(new Sequence(sb.toString()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("unable to parse sequences file " + filename);
        }
        Sequence[] res = new Sequence[resa.size()];
        return resa.toArray(res);
    }

    public static Sequence[] loadWeighted(String filename, int minLength) {
        ArrayList<Sequence> resa = new ArrayList<Sequence>();
        try {
            String s;
            BufferedReader bin = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
            StringBuilder sb = new StringBuilder();
            double weight = 0.0;
            while ((s = bin.readLine()) != null) {
                if (s.length() > 0 && s.charAt(0) == '>') {
                    if (sb.length() >= minLength) {
                        resa.add(new Sequence(sb.toString(), weight));
                    }
                    sb.setLength(0);
                    weight = Double.parseDouble(s.substring(1).trim().split(" ")[0]);
                    continue;
                }
                sb.append(s.trim());
            }
            if (sb.length() >= minLength) {
                resa.add(new Sequence(sb.toString(), weight));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("unable to parse sequences file " + filename);
        }
        Sequence[] res = new Sequence[resa.size()];
        return resa.toArray(res);
    }

    public static Peak[] loadPeaks(String filename, int minLength) {
        ArrayList<Peak> resa = new ArrayList<Peak>();
        try {
            String s;
            BufferedReader bin = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
            StringBuilder sb = new StringBuilder();
            double[] profile = null;
            while ((s = bin.readLine()) != null) {
                if (s.length() != 0 && s.charAt(0) == '>') {
                    String[] pivis = s.substring(1).trim().split(" ");
                    if (sb.length() >= minLength) {
                        if (profile.length != sb.length()) {
                            throw new IOException("the profile length is not equal to the sequence length in the multifasta");
                        }
                        resa.add(new Peak(sb.toString(), profile));
                    }
                    sb.setLength(0);
                    profile = new double[pivis.length];
                    for (int i = 0; i < pivis.length; ++i) {
                        profile[i] = Double.parseDouble(pivis[i]);
                    }
                    continue;
                }
                sb.append(s.trim());
            }
            if (sb.length() >= minLength) {
                if (profile.length != sb.length()) {
                    throw new IOException("the profile length is not equal to the sequence length in the multifasta");
                }
                resa.add(new Peak(sb.toString(), profile));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("unable to parse the sequences file " + filename);
        }
        Peak[] res = new Peak[resa.size()];
        return resa.toArray(res);
    }

    public static Sequence[] joinSeqsa(int size, List<Sequence[]> sequences) {
        ArrayList<Sequence> list = new ArrayList<Sequence>(size);
        for (Sequence[] array : sequences) {
            list.addAll(Arrays.asList(array));
        }
        return list.toArray(new Sequence[size]);
    }

    private static int countSequences(List<Sequence[]> preprocessedSets) {
        int count = 0;
        for (Sequence[] array : preprocessedSets) {
            count += array.length;
        }
        return count;
    }

    private List<Sequence[]> preprocessFilter(List<MunkResult> preprocessList) {
        ArrayList<Sequence[]> result = new ArrayList<Sequence[]>(this.sequenceSets.size());
        for (Sequence[] sequenceSet : this.sequenceSets) {
            ArrayList<Sequence> nonfiltered = new ArrayList<Sequence>(sequenceSet.length);
            for (Sequence s : sequenceSet) {
                double threshold;
                WPCM pm;
                boolean filter = false;
                int preprocessListSize = preprocessList.size();
                for (int i = 0; i < preprocessListSize && !(filter = s.hasOccurrence(pm = preprocessList.get(i).getPWM(), threshold = preprocessList.get(i).getThreshold())); ++i) {
                }
                if (filter) continue;
                nonfiltered.add(s);
            }
            if (nonfiltered.size() <= 0) continue;
            result.add(nonfiltered.toArray(new Sequence[nonfiltered.size()]));
        }
        return result;
    }

    private List<Sequence[]> preprocessMask(List<MunkResult> preprocessList) {
        ArrayList<Sequence[]> result = new ArrayList<Sequence[]>(this.sequenceSets.size());
        for (Sequence[] sequenceSet : this.sequenceSets) {
            ArrayList<Sequence> maskedSet = new ArrayList<Sequence>(sequenceSet.length);
            for (Sequence s : sequenceSet) {
                Sequence masked = s.copy();
                Integer rclength = masked.getRevcomp() == null ? null : Integer.valueOf(masked.getRevcomp().length);
                int preprocessListSize = preprocessList.size();
                for (int i = 0; i < preprocessListSize; ++i) {
                    WPCM pm = preprocessList.get(i).getPWM();
                    double threshold = preprocessList.get(i).getThreshold();
                    for (Occurrence occ : s.gatherOccurrences(pm, threshold)) {
                        int position;
                        for (int j = position = occ.getPosition(); j < position + pm.length(); ++j) {
                            masked.getDirect()[j] = (byte)Din.NN.ordinal();
                            masked.getRevcomp()[rclength.intValue() - j - 1] = (byte)Din.NN.ordinal();
                        }
                    }
                }
                maskedSet.add(masked);
            }
            result.add(maskedSet.toArray(new Sequence[maskedSet.size()]));
        }
        return result;
    }

    public static void prettyOutputWPCM(Conductor conductor, double[][] matrix) {
        double weight = 0.0;
        for (byte i = 0; i <= 15; i = (byte)(i + 1)) {
            String s = Conductor.prettyString(matrix[i]);
            conductor.output((Object)Din.map.get(i), s);
            weight += matrix[i][0];
        }
        conductor.output("NN", weight);
    }

    public static void prettyOutputPWM(Conductor conductor, double[][] matrix) {
        for (byte i = 0; i <= 15; i = (byte)(i + 1)) {
            String s = Conductor.prettyString(matrix[i]);
            conductor.output("PW" + (Object)((Object)Din.map.get(i)), s);
        }
    }

    public static void prettyOutputBackground(Conductor conductor, double[] background) {
        conductor.output("ORDR", "AA AC AG AT CA CC CG CT GA GC GG GT TA TC TG TT");
        StringBuilder baks = new StringBuilder();
        baks.append(background[Din.AA.ordinal()]).append(" ");
        baks.append(background[Din.AC.ordinal()]).append(" ");
        baks.append(background[Din.AG.ordinal()]).append(" ");
        baks.append(background[Din.AT.ordinal()]).append(" ");
        baks.append(background[Din.CA.ordinal()]).append(" ");
        baks.append(background[Din.CC.ordinal()]).append(" ");
        baks.append(background[Din.CG.ordinal()]).append(" ");
        baks.append(background[Din.CT.ordinal()]).append(" ");
        baks.append(background[Din.GA.ordinal()]).append(" ");
        baks.append(background[Din.GC.ordinal()]).append(" ");
        baks.append(background[Din.GG.ordinal()]).append(" ");
        baks.append(background[Din.GT.ordinal()]).append(" ");
        baks.append(background[Din.TA.ordinal()]).append(" ");
        baks.append(background[Din.TC.ordinal()]).append(" ");
        baks.append(background[Din.TG.ordinal()]).append(" ");
        baks.append(background[Din.TT.ordinal()]);
        conductor.output("BACK", baks.toString());
    }

    public static class Parameters {
        private Conductor conductor;
        private ChIPApp.PreprocessMode preprocessMode;
        private List<MunkResult> preprocessList;
        private List<Sequence[]> sequenceSets;
        private Integer motifLength;
        private int threadCount;
        private int iterationLimit;
        private int stepLimit;
        private int tryLimit;
        private boolean logWeighting;
        private boolean localBackground;
        private double[] shape;

        public Parameters(Conductor conductor, ChIPApp.PreprocessMode preprocessMode, List<MunkResult> preprocessList, List<Sequence[]> sequenceSets, int motifLength, int tryLimit, int stepLimit, int iterationLimit, int threadCount, boolean localBackground, boolean logWeighting) {
            this.conductor = conductor;
            this.preprocessMode = preprocessMode;
            this.preprocessList = preprocessList;
            this.sequenceSets = sequenceSets;
            this.motifLength = motifLength;
            this.threadCount = threadCount;
            this.iterationLimit = iterationLimit;
            this.stepLimit = stepLimit;
            this.tryLimit = tryLimit;
            this.logWeighting = logWeighting;
            this.localBackground = localBackground;
        }

        public Parameters(Conductor conductor, List<Sequence[]> sequenceSets, Integer motifLength) {
            this.conductor = conductor;
            this.preprocessMode = null;
            this.preprocessList = null;
            this.sequenceSets = sequenceSets;
            this.motifLength = motifLength;
            this.threadCount = 2;
            this.iterationLimit = 1;
            this.stepLimit = 20;
            this.tryLimit = 200;
            this.logWeighting = true;
            this.localBackground = false;
        }

        public Parameters(Conductor conductor, List<Sequence[]> sequenceSets) {
            this(conductor, sequenceSets, null);
        }

        public Conductor getConductor() {
            return this.conductor;
        }

        public ChIPApp.PreprocessMode getPreprocessMode() {
            return this.preprocessMode;
        }

        public List<MunkResult> getPreprocessList() {
            return this.preprocessList;
        }

        public List<Sequence[]> getSequenceSets() {
            return this.sequenceSets;
        }

        public int getMotifLength() {
            return this.motifLength;
        }

        public int getThreadCount() {
            return this.threadCount;
        }

        public int getIterationLimit() {
            return this.iterationLimit;
        }

        public int getStepLimit() {
            return this.stepLimit;
        }

        public int getTryLimit() {
            return this.tryLimit;
        }

        public boolean isLogWeighting() {
            return this.logWeighting;
        }

        public boolean isLocalBackground() {
            return this.localBackground;
        }

        public double[] getShape() {
            return this.shape;
        }

        public void setPreprocessMode(ChIPApp.PreprocessMode preprocessMode) {
            this.preprocessMode = preprocessMode;
        }

        public void setPreprocessList(List<MunkResult> preprocessList) {
            this.preprocessList = preprocessList;
        }

        public void setThreadCount(int threadCount) {
            this.threadCount = threadCount;
        }

        public void setIterationLimit(int iterationLimit) {
            this.iterationLimit = iterationLimit;
        }

        public void setStepLimit(int stepLimit) {
            this.stepLimit = stepLimit;
        }

        public void setTryLimit(int tryLimit) {
            this.tryLimit = tryLimit;
        }

        public void setLogWeighting(boolean logWeighting) {
            this.logWeighting = logWeighting;
        }

        public void setLocalBackground(boolean localBackground) {
            this.localBackground = localBackground;
        }

        public void setMotifLength(int motifLength) {
            this.motifLength = motifLength;
        }

        public void setShape(double[] shape) {
            this.shape = shape;
        }
    }
}

