/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.converters;

import ru.autosome.perfectosape.motifModels.Named;
import ru.autosome.perfectosape.motifModels.PositionCountModel;
import ru.autosome.perfectosape.motifModels.PositionFrequencyModel;

public class PCM2PPMConverter<ModelTypeFrom extends PositionCountModel & Named, ModelTypeTo extends PositionFrequencyModel & Named> {
    private final ModelTypeFrom pcm;
    private final Class<ModelTypeTo> toClass;

    public PCM2PPMConverter(ModelTypeFrom pcm, Class<ModelTypeTo> toClass) {
        this.pcm = pcm;
        this.toClass = toClass;
    }

    double count(double[] pos) {
        double count = 0.0;
        for (double element : pos) {
            count += element;
        }
        return count;
    }

    double[] convert_position(double[] pos) {
        double count = this.count(pos);
        double[] converted_pos = new double[this.pcm.alphabetSize()];
        for (int letter = 0; letter < this.pcm.alphabetSize(); ++letter) {
            converted_pos[letter] = pos[letter] / count;
        }
        return converted_pos;
    }

    public ModelTypeTo convert() {
        double[][] new_matrix = new double[this.pcm.getMatrix().length][];
        for (int pos = 0; pos < this.pcm.getMatrix().length; ++pos) {
            new_matrix[pos] = this.convert_position(this.pcm.getMatrix()[pos]);
        }
        try {
            return (ModelTypeTo)((PositionFrequencyModel)this.toClass.getConstructor(double[][].class, String.class).newInstance(new Object[]{new_matrix, ((Named)this.pcm).getName()}));
        }
        catch (Exception exception) {
            throw new Error("Should not be here", exception);
        }
    }
}

