/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import ru.autosome.perfectosape.SequenceWithSNP;
import ru.autosome.perfectosape.backgroundModels.GeneralizedBackgroundModel;
import ru.autosome.perfectosape.calculations.HashOverflowException;
import ru.autosome.perfectosape.calculations.SNPScan;
import ru.autosome.perfectosape.calculations.findPvalue.CanFindPvalue;
import ru.autosome.perfectosape.importers.InputExtensions;
import ru.autosome.perfectosape.motifModels.DataModel;
import ru.autosome.perfectosape.motifModels.ScoringModel;

public abstract class MultiSNPScanGeneralized<BackgroundType extends GeneralizedBackgroundModel> {
    protected Double discretization;
    protected Integer max_hash_size;
    protected File path_to_collection_of_pwms;
    protected File path_to_file_w_snps;
    protected DataModel dataModel;
    protected double effectiveCount;
    protected File thresholds_folder;
    protected List<String> snp_list;
    List<ThresholdEvaluator> pwmCollection;
    protected double max_pvalue_cutoff;
    protected double min_fold_change_cutoff;
    protected BackgroundType background;

    protected abstract void initialize_default_background();

    abstract void extract_background(String var1);

    protected abstract void load_collection_of_pwms() throws FileNotFoundException;

    protected abstract String DOC_background_option();

    protected abstract String DOC_run_string();

    String documentString() {
        return "Command-line format:\n" + this.DOC_run_string() + " <folder with pwms> <file with SNPs> [options]\n\nOptions:\n  [--pvalue-cutoff <maximal pvalue to be considered>] or [-P] - drop results having both allele-variant pvalues greater than given\n                                                       (default: 0.0005)\n  [--fold-change-cutoff <minmal fold change to be considered>] or [-F] - drop results having fold change (both 1st pvalue to 2nd, 2nd to 1st)\n                                                                 less than given (default: 5)\n        In order to get all fold changes - set both pvalue-cutoff and fold-change-cutoff to 1.0.\n  [-d <discretization level>]\n  [--pcm] - treat the input file as Position Count Matrix. PCM-to-PWM transformation to be done internally.\n  [--ppm] or [--pfm] - treat the input file as Position Frequency Matrix. PPM-to-PWM transformation to be done internally.\n  [--effective-count <count>] - effective samples set size for PPM-to-PWM conversion (default: 100). \n  [-b <background probabilities] " + this.DOC_background_option() + "\n  [--precalc <folder>] - specify folder with thresholds for PWM collection (for fast-and-rough calculation).\n\nExamples:\n  " + this.DOC_run_string() + " ./hocomoco/pwms/ snp.txt --precalc ./collection_thresholds\n  " + this.DOC_run_string() + " ./hocomoco/pcms/ snp.txt --pcm -d 10\n";
    }

    protected static String last_part_of_string(String s) {
        String[] string_parts = s.replaceAll("\\s+", " ").split(" ");
        String result = string_parts[string_parts.length - 1];
        if (result.matches("[ACGTacgt]+(/[ACGTacgt]+)+") || result.matches("[ACGTacgt]+\\[(/?[ACGTacgt]+)+\\][ACGTacgt]+")) {
            return result;
        }
        return string_parts[string_parts.length - 3] + "[" + string_parts[string_parts.length - 2].replaceAll("\\[|\\]", "") + "]" + string_parts[string_parts.length - 1];
    }

    protected static String first_part_of_string(String s) {
        return s.replaceAll("\\s+", " ").split(" ")[0];
    }

    void extract_path_to_collection_of_pwms(ArrayList<String> argv) {
        try {
            this.path_to_collection_of_pwms = new File(argv.remove(0));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Specify PWM-collection folder", e);
        }
    }

    void extract_path_to_file_w_snps(ArrayList<String> argv) {
        try {
            this.path_to_file_w_snps = new File(argv.remove(0));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Specify file with SNPs", e);
        }
    }

    protected void initialize_defaults() {
        this.initialize_default_background();
        this.discretization = 100.0;
        this.max_hash_size = 10000000;
        this.dataModel = DataModel.PWM;
        this.effectiveCount = 100.0;
        this.thresholds_folder = null;
        this.max_pvalue_cutoff = 5.0E-4;
        this.min_fold_change_cutoff = 5.0;
    }

    protected MultiSNPScanGeneralized() {
        this.initialize_defaults();
    }

    void setup_from_arglist(ArrayList<String> argv) throws FileNotFoundException {
        this.extract_path_to_collection_of_pwms(argv);
        this.extract_path_to_file_w_snps(argv);
        while (argv.size() > 0) {
            this.extract_option(argv);
        }
        this.load_collection_of_pwms();
        this.load_snp_list();
    }

    protected void extract_option(ArrayList<String> argv) {
        String opt = argv.remove(0);
        if (opt.equals("-b")) {
            this.extract_background(argv.remove(0));
        } else if (opt.equals("--max-hash-size")) {
            this.max_hash_size = Integer.valueOf(argv.remove(0));
        } else if (opt.equals("-d")) {
            this.discretization = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--pcm")) {
            this.dataModel = DataModel.PCM;
        } else if (opt.equals("--ppm") || opt.equals("--pfm")) {
            this.dataModel = DataModel.PPM;
        } else if (opt.equals("--effective-count")) {
            this.effectiveCount = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--precalc")) {
            this.thresholds_folder = new File(argv.remove(0));
        } else if (opt.equals("--pvalue-cutoff") || opt.equals("-P")) {
            this.max_pvalue_cutoff = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--fold-change-cutoff") || opt.equals("-F")) {
            this.min_fold_change_cutoff = Double.valueOf(argv.remove(0));
            if (this.min_fold_change_cutoff < 1.0) {
                this.min_fold_change_cutoff = 1.0 / this.min_fold_change_cutoff;
            }
        } else {
            throw new IllegalArgumentException("Unknown option '" + opt + "'");
        }
    }

    protected void load_snp_list() {
        try {
            FileInputStream reader = new FileInputStream(this.path_to_file_w_snps);
            this.snp_list = InputExtensions.filter_empty_strings(InputExtensions.readLinesFromInputStream(reader));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to load pack of SNPs", e);
        }
    }

    protected void process_snp(String snp_input) throws HashOverflowException {
        String snp_name = MultiSNPScanGeneralized.first_part_of_string(snp_input);
        SequenceWithSNP seq_w_snp = SequenceWithSNP.fromString(MultiSNPScanGeneralized.last_part_of_string(snp_input));
        for (ThresholdEvaluator motifEvaluator : this.pwmCollection) {
            boolean foldChangeSignificant;
            SNPScan.RegionAffinityInfos result = new SNPScan(motifEvaluator.pwm, seq_w_snp, motifEvaluator.pvalueCalculator).affinityInfos();
            boolean pvalueSignificant = result.getInfo_1().getPvalue() <= this.max_pvalue_cutoff || result.getInfo_2().getPvalue() <= this.max_pvalue_cutoff;
            boolean bl = foldChangeSignificant = result.foldChange() >= this.min_fold_change_cutoff || result.foldChange() <= 1.0 / this.min_fold_change_cutoff;
            if (!pvalueSignificant || !foldChangeSignificant) continue;
            System.out.println(snp_name + "\t" + motifEvaluator.name + "\t" + result.toString());
        }
    }

    void process() throws HashOverflowException {
        System.out.println("# SNP name\tmotif\tposition 1\torientation 1\tword 1\tposition 2\torientation 2\tword 2\tallele 1/allele 2\tP-value 1\tP-value 2\tFold change");
        for (String snp_input : this.snp_list) {
            this.process_snp(snp_input);
        }
    }

    public static class ThresholdEvaluator {
        public ScoringModel pwm;
        public CanFindPvalue pvalueCalculator;
        public String name;

        public ThresholdEvaluator(ScoringModel pwm, CanFindPvalue pvalueCalculator, String name) {
            this.pwm = pwm;
            this.pvalueCalculator = pvalueCalculator;
            this.name = name;
        }
    }
}

