/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.backgroundModels;

import java.util.StringTokenizer;
import ru.autosome.perfectosape.ArrayExtensions;
import ru.autosome.perfectosape.backgroundModels.BackgroundModel;
import ru.autosome.perfectosape.backgroundModels.DiBackgroundModel;
import ru.autosome.perfectosape.backgroundModels.DiWordwiseBackground;

public class DiBackground
implements DiBackgroundModel {
    private double[] background;
    private double[][] _conditionalProbabilities;

    public DiBackground(double[] background) {
        if (Math.abs(ArrayExtensions.sum(background) - 1.0) > 1.0E-4) {
            throw new IllegalArgumentException("Background probabilities should be 1.0 being summarized");
        }
        this.background = background;
    }

    public static DiBackgroundModel fromArray(double[] background) {
        if (background.length != 16) {
            throw new IllegalArgumentException("Background constructor accepts double array of length 16");
        }
        boolean wordwise = true;
        for (int i = 0; i < 16; ++i) {
            if (!(Math.abs(background[i] - 1.0) > 1.0E-4)) continue;
            wordwise = false;
        }
        if (wordwise) {
            return new DiWordwiseBackground();
        }
        return new DiBackground(background);
    }

    public static DiBackgroundModel fromMonoBackground(BackgroundModel backgroundModel) {
        if (backgroundModel.is_wordwise()) {
            return new DiWordwiseBackground();
        }
        double[] background = new double[16];
        for (int letter = 0; letter < 4; ++letter) {
            for (int previousLetter = 0; previousLetter < 4; ++previousLetter) {
                background[4 * previousLetter + letter] = backgroundModel.probability(letter) / 4.0;
            }
        }
        return new DiBackground(background);
    }

    @Override
    public double probability(int index) {
        return this.background[index];
    }

    @Override
    public double conditionalCount(int previousLetter, int letter) {
        return this.conditionalProbabilities()[previousLetter][letter];
    }

    @Override
    public double countAnyFirstLetter(int secondLetter) {
        double probabilityAnyLetter = 0.0;
        for (int firstLetter = 0; firstLetter < 4; ++firstLetter) {
            probabilityAnyLetter += this.probability(4 * firstLetter + secondLetter);
        }
        return probabilityAnyLetter;
    }

    @Override
    public double countAnySecondLetter(int firstLetter) {
        double probabilityAnyLetter = 0.0;
        for (int secondLetter = 0; secondLetter < 4; ++secondLetter) {
            probabilityAnyLetter += this.probability(4 * firstLetter + secondLetter);
        }
        return probabilityAnyLetter;
    }

    private double[][] conditionalProbabilities() {
        if (this._conditionalProbabilities == null) {
            this._conditionalProbabilities = new double[4][4];
            for (int letterInCondition = 0; letterInCondition < 4; ++letterInCondition) {
                for (int letter = 0; letter < 4; ++letter) {
                    this._conditionalProbabilities[letterInCondition][letter] = this.probability(4 * letterInCondition + letter) / this.countAnySecondLetter(letterInCondition);
                }
            }
        }
        return this._conditionalProbabilities;
    }

    @Override
    public double volume() {
        return 1.0;
    }

    public static DiBackgroundModel fromString(String s) {
        double[] background = new double[16];
        StringTokenizer parser = new StringTokenizer(s);
        for (int i = 0; i < 16; ++i) {
            background[i] = Double.valueOf(parser.nextToken(","));
        }
        return DiBackground.fromArray(background);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            if (i != 0) {
                builder.append(',');
            }
            builder.append(this.background[i]);
        }
        return builder.toString();
    }

    @Override
    public boolean is_wordwise() {
        return false;
    }

    @Override
    public double mean_value(double[] values) {
        double result = 0.0;
        for (int letter = 0; letter < 16; ++letter) {
            result += values[letter] * this.probability(letter);
        }
        return result;
    }

    @Override
    public double mean_square_value(double[] values) {
        double mean_square = 0.0;
        for (int letter = 0; letter < 16; ++letter) {
            mean_square += values[letter] * values[letter] * this.probability(letter);
        }
        return mean_square;
    }
}

