/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape;

import gnu.trove.impl.unmodifiable.TUnmodifiableCharCharMap;
import gnu.trove.map.TCharCharMap;
import gnu.trove.map.hash.TCharCharHashMap;
import java.util.ArrayList;
import ru.autosome.perfectosape.Position;

public class Sequence {
    private static final TCharCharMap complements = new TUnmodifiableCharCharMap(new TCharCharHashMap(new char[]{'A', 'C', 'G', 'T', 'a', 'c', 'g', 't'}, new char[]{'T', 'G', 'C', 'A', 't', 'g', 'c', 'a'}));
    public final String sequence;

    public Sequence(String sequence) {
        this.sequence = sequence;
    }

    public int length() {
        return this.sequence.length();
    }

    public Sequence reverse() {
        return new Sequence(new StringBuilder(this.sequence).reverse().toString());
    }

    public Sequence complement() {
        StringBuilder result = new StringBuilder(this.length());
        for (int i = 0; i < this.sequence.length(); ++i) {
            result.append(complements.get(this.sequence.charAt(i)));
        }
        return new Sequence(result.toString());
    }

    public Sequence substring(int beginIndex, int endIndex) {
        return new Sequence(this.sequence.substring(beginIndex, endIndex));
    }

    public Sequence substring(Position left_boundary, int substring_length) {
        Sequence unorientedWord = this.substring(left_boundary.position, Math.min(left_boundary.position + substring_length, this.length()));
        if (left_boundary.directStrand) {
            return unorientedWord;
        }
        return unorientedWord.reverse().complement();
    }

    public ArrayList<Position> subsequence_positions(int subsequence_length) {
        return Position.positions_between(0, this.length(), subsequence_length);
    }

    public String toString() {
        return this.sequence;
    }
}

