/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.di.ytilib;

import ru.autosome.assist.ASequence;
import ru.autosome.di.ytilib.Din;
import ru.autosome.di.ytilib.WPCM;

public class Sequence
extends ASequence {
    public static final double[] uniformBackground = new double[Din.dins];

    public Sequence(Sequence sour) {
        this.weight = sour.weight;
        this.direct = sour.direct;
        this.revcomp = sour.revcomp;
        this.hdirect = new double[this.direct.length];
        this.hrevcomp = new double[this.revcomp.length];
    }

    public Sequence(String sour) {
        this.weight = 1.0;
        sour = sour.toUpperCase();
        sour = sour.replaceAll("U", "T").replaceAll("[^ACGT]", "N");
        this.direct = new byte[sour.length() - 1];
        for (int i = 0; i < sour.length() - 1; ++i) {
            this.direct[i] = (byte)Din.valueOf(sour.substring(i, i + 2)).ordinal();
        }
        this.revcomp = this.revcomp();
        this.hdirect = new double[this.direct.length];
        this.hrevcomp = new double[this.revcomp.length];
    }

    public Sequence(String sour, double weight) {
        this(sour);
        this.weight = weight;
    }

    public Sequence(Sequence seqc, double weight) {
        this.weight = weight;
        this.direct = seqc.direct;
        this.revcomp = seqc.revcomp;
        this.hdirect = new double[this.direct.length];
        this.hrevcomp = new double[this.revcomp.length];
    }

    public Sequence(byte[] cdirect, byte[] crevcomp, double weight) {
        this.weight = weight;
        this.direct = cdirect;
        this.revcomp = crevcomp;
        this.hdirect = new double[this.direct.length];
        this.hrevcomp = new double[this.revcomp == null ? 0 : this.revcomp.length];
    }

    @Override
    public byte[] revcomp() {
        byte[] strand2 = new byte[this.direct.length];
        for (int i = 0; i < this.direct.length; ++i) {
            strand2[strand2.length - i - 1] = Din.REVCOMP[this.direct[i]];
        }
        return strand2;
    }

    public static byte[] str2seq(String s) {
        return new Sequence((String)s).direct;
    }

    public static String seq2str(byte[] seq) {
        StringBuilder str = new StringBuilder();
        str.append((Object)Din.map.get(seq[0]));
        for (int i = 1; i < seq.length; ++i) {
            str.append(Din.map.get(seq[i]).toString().substring(1, 2));
        }
        return str.toString();
    }

    @Override
    public String word2str(byte[] seq, int offset, int length) {
        StringBuilder str = new StringBuilder();
        str.append((Object)Din.map.get(seq[offset]));
        for (int i = offset + 1; i < offset + length; ++i) {
            str.append(Din.map.get(seq[i]).toString().substring(1, 2));
        }
        return str.toString();
    }

    @Override
    public Sequence copy() {
        byte[] cdirect = new byte[this.direct.length];
        byte[] crevcomp = new byte[this.revcomp.length];
        System.arraycopy(this.direct, 0, cdirect, 0, this.direct.length);
        System.arraycopy(this.revcomp, 0, crevcomp, 0, this.revcomp.length);
        return new Sequence(cdirect, crevcomp, this.weight);
    }

    public static double[] background(Sequence[] sequences) {
        double[] probs = new double[Din.dins];
        int total_length = 0;
        for (Sequence sequence : sequences) {
            total_length += sequence.direct.length;
            for (int i = 0; i < sequence.direct.length; ++i) {
                if (sequence.revcomp != null) {
                    byte by = sequence.direct[i];
                    probs[by] = probs[by] + 0.5;
                    byte by2 = sequence.revcomp[i];
                    probs[by2] = probs[by2] + 0.5;
                    continue;
                }
                byte by = sequence.direct[i];
                probs[by] = probs[by] + 1.0;
            }
        }
        double NA = probs[(byte)Din.NA.ordinal()] / 4.0;
        byte by = (byte)Din.AA.ordinal();
        probs[by] = probs[by] + NA;
        byte by3 = (byte)Din.CA.ordinal();
        probs[by3] = probs[by3] + NA;
        byte by4 = (byte)Din.GA.ordinal();
        probs[by4] = probs[by4] + NA;
        byte by5 = (byte)Din.TA.ordinal();
        probs[by5] = probs[by5] + NA;
        double AN = probs[(byte)Din.AN.ordinal()] / 4.0;
        byte by6 = (byte)Din.AA.ordinal();
        probs[by6] = probs[by6] + AN;
        byte by7 = (byte)Din.AC.ordinal();
        probs[by7] = probs[by7] + AN;
        byte by8 = (byte)Din.AG.ordinal();
        probs[by8] = probs[by8] + AN;
        byte by9 = (byte)Din.AT.ordinal();
        probs[by9] = probs[by9] + AN;
        double NC = probs[(byte)Din.NC.ordinal()] / 4.0;
        byte by10 = (byte)Din.AC.ordinal();
        probs[by10] = probs[by10] + NC;
        byte by11 = (byte)Din.CC.ordinal();
        probs[by11] = probs[by11] + NC;
        byte by12 = (byte)Din.GC.ordinal();
        probs[by12] = probs[by12] + NC;
        byte by13 = (byte)Din.TC.ordinal();
        probs[by13] = probs[by13] + NC;
        double CN = probs[(byte)Din.CN.ordinal()] / 4.0;
        byte by14 = (byte)Din.CA.ordinal();
        probs[by14] = probs[by14] + CN;
        byte by15 = (byte)Din.CC.ordinal();
        probs[by15] = probs[by15] + CN;
        byte by16 = (byte)Din.CG.ordinal();
        probs[by16] = probs[by16] + CN;
        byte by17 = (byte)Din.CT.ordinal();
        probs[by17] = probs[by17] + CN;
        double NG = probs[(byte)Din.NG.ordinal()] / 4.0;
        byte by18 = (byte)Din.AG.ordinal();
        probs[by18] = probs[by18] + NG;
        byte by19 = (byte)Din.CG.ordinal();
        probs[by19] = probs[by19] + NG;
        byte by20 = (byte)Din.GG.ordinal();
        probs[by20] = probs[by20] + NG;
        byte by21 = (byte)Din.TG.ordinal();
        probs[by21] = probs[by21] + NG;
        double GN = probs[(byte)Din.GN.ordinal()] / 4.0;
        byte by22 = (byte)Din.GA.ordinal();
        probs[by22] = probs[by22] + GN;
        byte by23 = (byte)Din.GC.ordinal();
        probs[by23] = probs[by23] + GN;
        byte by24 = (byte)Din.GG.ordinal();
        probs[by24] = probs[by24] + GN;
        byte by25 = (byte)Din.GT.ordinal();
        probs[by25] = probs[by25] + GN;
        double NT = probs[(byte)Din.NT.ordinal()] / 4.0;
        byte by26 = (byte)Din.AT.ordinal();
        probs[by26] = probs[by26] + NT;
        byte by27 = (byte)Din.CT.ordinal();
        probs[by27] = probs[by27] + NT;
        byte by28 = (byte)Din.GT.ordinal();
        probs[by28] = probs[by28] + NT;
        byte by29 = (byte)Din.TT.ordinal();
        probs[by29] = probs[by29] + NT;
        double TN = probs[(byte)Din.TN.ordinal()] / 4.0;
        byte by30 = (byte)Din.TA.ordinal();
        probs[by30] = probs[by30] + TN;
        byte by31 = (byte)Din.TC.ordinal();
        probs[by31] = probs[by31] + TN;
        byte by32 = (byte)Din.TG.ordinal();
        probs[by32] = probs[by32] + TN;
        byte by33 = (byte)Din.TT.ordinal();
        probs[by33] = probs[by33] + TN;
        double NN = probs[(byte)Din.NN.ordinal()] / 16.0;
        for (byte b = (byte)Din.AA.ordinal(); b <= (byte)Din.TT.ordinal(); b = (byte)(b + 1)) {
            byte by34 = b;
            probs[by34] = probs[by34] + NN;
        }
        int i = 0;
        while (i < probs.length) {
            int n = i++;
            probs[n] = probs[n] / (double)total_length;
        }
        WPCM.iupacomprobs(probs);
        return probs;
    }

    static {
        for (int i = 0; i < Din.values().length; ++i) {
            Sequence.uniformBackground[i] = 0.0625;
        }
    }
}

