/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.motifModels;

import ru.autosome.perfectosape.backgroundModels.DiBackgroundModel;
import ru.autosome.perfectosape.converters.PCM2PPMConverter;
import ru.autosome.perfectosape.converters.PCM2PWMConverter;
import ru.autosome.perfectosape.importers.PMParser;
import ru.autosome.perfectosape.motifModels.DiPM;
import ru.autosome.perfectosape.motifModels.DiPPM;
import ru.autosome.perfectosape.motifModels.DiPWM;
import ru.autosome.perfectosape.motifModels.PositionCountModel;

public class DiPCM
extends DiPM
implements PositionCountModel {
    public DiPCM(double[][] matrix, String name) throws IllegalArgumentException {
        super(matrix, name);
    }

    public double count() {
        double[] pos = this.getMatrix()[0];
        double sum = 0.0;
        for (int i = 0; i < this.alphabetSize(); ++i) {
            sum += pos[i];
        }
        return sum;
    }

    public DiPWM to_pwm(DiBackgroundModel background) {
        PCM2PWMConverter<DiPCM, DiPWM> converter = new PCM2PWMConverter<DiPCM, DiPWM>(this, DiPWM.class);
        converter.background = background;
        return converter.convert();
    }

    public DiPPM to_ppm(DiBackgroundModel background) {
        return new PCM2PPMConverter<DiPCM, DiPPM>(this, DiPPM.class).convert();
    }

    public static DiPCM fromParser(PMParser parser) {
        if (parser == null) {
            return null;
        }
        double[][] matrix = parser.matrix();
        String name = parser.name();
        return new DiPCM(matrix, name);
    }
}

