/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.examples;

import java.util.ArrayList;
import java.util.Map;
import ru.autosome.perfectosape.BoundaryType;
import ru.autosome.perfectosape.SequenceWithSNP;
import ru.autosome.perfectosape.api.MultiSNPScan;
import ru.autosome.perfectosape.api.PrecalculateThresholdLists;
import ru.autosome.perfectosape.backgroundModels.WordwiseBackground;
import ru.autosome.perfectosape.calculations.PrecalculateThresholdList;
import ru.autosome.perfectosape.calculations.SNPScan;
import ru.autosome.perfectosape.calculations.findPvalue.CanFindPvalue;
import ru.autosome.perfectosape.importers.PMParser;
import ru.autosome.perfectosape.motifModels.PPM;
import ru.autosome.perfectosape.motifModels.PWM;

public class MultiSNPScan {
    public static void main(String[] args) {
        double[] pvalues = PrecalculateThresholdList.PVALUE_LIST;
        double discretization = 10000.0;
        WordwiseBackground background = new WordwiseBackground();
        BoundaryType pvalue_boundary = BoundaryType.LOWER;
        Integer max_hash_size = null;
        double ppm_effective_count = 100.0;
        ArrayList<PWM> pwmCollection = new ArrayList<PWM>();
        pwmCollection.add(PWM.fromParser(PMParser.from_file_or_stdin("test_data/pwm/KLF4_f2.pwm")));
        pwmCollection.add(PWM.fromParser(PMParser.from_file_or_stdin("test_data/pwm/SP1_f1.pwm")));
        double[][] matrix_cAVNCT = new double[][]{{1.0, 2.0, 1.0, 1.0}, {10.5, -3.0, 0.0, 0.0}, {5.0, 5.0, 5.0, -10.0}, {0.0, 0.0, 0.0, 0.0}, {-1.0, 10.5, -1.0, 0.0}, {0.0, 0.0, 0.0, 2.0}};
        PWM pwm_manual_constructed = new PWM(matrix_cAVNCT, "PWM for cAVNCt consensus sequence (name of PWM)");
        pwmCollection.add(pwm_manual_constructed);
        double[][] ppm_matrix = new double[][]{{0.2, 0.4, 0.2, 0.2}, {0.9, 0.0, 0.05, 0.05}, {0.3, 0.3, 0.3, 0.1}, {0.25, 0.25, 0.25, 0.25}, {0.0, 0.9, 0.0, 0.1}, {0.2, 0.2, 0.2, 0.4}};
        PPM ppm = new PPM(ppm_matrix, "cAVNCt PPM (slightly different from another cAVNCt matrix)");
        PWM pwm_from_ppm = ppm.to_pwm(background, ppm_effective_count);
        pwmCollection.add(pwm_from_ppm);
        ArrayList<SequenceWithSNP> snpCollection = new ArrayList<SequenceWithSNP>();
        snpCollection.add(SequenceWithSNP.fromString("AAGGTCAATACTCAACATCATAAAAACAGACAAAAGTATAAAACTTACAG[C/G]GTCTTACAAAAAGGATGATCCAGTAATATGCTGCTTACAAGAAACCCACC"));
        snpCollection.add(new SequenceWithSNP("AGGGAAACAAAAATTGTTCGGAAAGGAGAACTAAGATGTATGAATGTTTC", new char[]{'G', 'T'}, "TTTTTAAGTGAAAAGTGTATAGTTCAGAGTGTAATATTTATTACCAGTAT"));
        PrecalculateThresholdLists.Parameters listCalculationParams = new PrecalculateThresholdLists.Parameters(pwmCollection, pvalues, discretization, background, pvalue_boundary, max_hash_size);
        PrecalculateThresholdLists listCalculator = new PrecalculateThresholdLists(listCalculationParams);
        Object pwmCollectionWithPvalueCalculators = listCalculator.call();
        MultiSNPScan.Parameters scan_parameters = new MultiSNPScan.Parameters(snpCollection, (Map<PWM, CanFindPvalue>)pwmCollectionWithPvalueCalculators);
        ru.autosome.perfectosape.api.MultiSNPScan scan_calculator = new ru.autosome.perfectosape.api.MultiSNPScan(scan_parameters);
        Object results = scan_calculator.call();
        for (PWM pwm : results.keySet()) {
            for (SequenceWithSNP seq : ((Map)results.get(pwm)).keySet()) {
                SNPScan.RegionAffinityInfos affinityInfos = (SNPScan.RegionAffinityInfos)((Map)results.get(pwm)).get(seq);
                System.out.println(pwm.name + " " + seq.toString() + " " + affinityInfos.toString());
            }
        }
    }
}

