/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.calculations;

import java.util.ArrayList;
import java.util.StringTokenizer;
import ru.autosome.perfectosape.ArrayExtensions;
import ru.autosome.perfectosape.BoundaryType;
import ru.autosome.perfectosape.PvalueBsearchList;
import ru.autosome.perfectosape.backgroundModels.GeneralizedBackgroundModel;
import ru.autosome.perfectosape.calculations.HashOverflowException;
import ru.autosome.perfectosape.calculations.findThreshold.CanFindThreshold;
import ru.autosome.perfectosape.calculations.findThreshold.FindThresholdAPE;
import ru.autosome.perfectosape.motifModels.Discretable;
import ru.autosome.perfectosape.motifModels.ScoringModel;

public class PrecalculateThresholdList<ModelType extends ScoringModel & Discretable<ModelType>, BackgroundType extends GeneralizedBackgroundModel> {
    public static final double[] PVALUE_LIST = new GeometricProgression(1.0E-15, 0.5, 1.05).values();
    double[] pvalues;
    BoundaryType pvalue_boundary;
    double discretization;
    BackgroundType background;
    Integer max_hash_size;

    public PrecalculateThresholdList(double[] pvalues, double discretization, BackgroundType background, BoundaryType pvalue_boundary, Integer max_hash_size) {
        this.pvalues = pvalues;
        this.discretization = discretization;
        this.background = background;
        this.pvalue_boundary = pvalue_boundary;
        this.max_hash_size = max_hash_size;
    }

    protected CanFindThreshold find_threshold_calculator(ModelType motif) {
        return new FindThresholdAPE<Discretable, BackgroundType>((Discretable)motif, this.background, this.discretization, this.max_hash_size);
    }

    public PvalueBsearchList bsearch_list_for_pwm(ModelType motif) throws HashOverflowException {
        CanFindThreshold.ThresholdInfo[] infos = this.find_threshold_calculator(motif).thresholdsByPvalues(this.pvalues, this.pvalue_boundary);
        ArrayList<PvalueBsearchList.ThresholdPvaluePair> pairs = new ArrayList<PvalueBsearchList.ThresholdPvaluePair>();
        for (CanFindThreshold.ThresholdInfo info : infos) {
            pairs.add(new PvalueBsearchList.ThresholdPvaluePair(info));
        }
        return new PvalueBsearchList(pairs);
    }

    public static class ArithmeticProgression
    extends Progression {
        double from;
        double to;
        double step;

        @Override
        public double[] values() {
            ArrayList<Double> results = new ArrayList<Double>();
            for (double x = this.from; x <= this.to; x += this.step) {
                results.add(x);
            }
            return ArrayExtensions.toPrimitiveArray(results);
        }

        ArithmeticProgression(double from, double to, double step) {
            this.from = from;
            this.to = to;
            this.step = step;
        }
    }

    public static class GeometricProgression
    extends Progression {
        double from;
        double to;
        double step;

        @Override
        public double[] values() {
            ArrayList<Double> results = new ArrayList<Double>();
            for (double x = this.from; x <= this.to; x *= this.step) {
                results.add(x);
            }
            return ArrayExtensions.toPrimitiveArray(results);
        }

        public GeometricProgression(double min, double to, double step) {
            this.from = min;
            this.to = to;
            this.step = step;
        }
    }

    public static abstract class Progression {
        public abstract double[] values();

        public static Progression fromString(String s) {
            StringTokenizer parser = new StringTokenizer(s);
            double min = Double.valueOf(parser.nextToken(","));
            double max = Double.valueOf(parser.nextToken(","));
            double step = Double.valueOf(parser.nextToken(","));
            String progression_method = parser.nextToken();
            if (progression_method.equals("mul")) {
                return new GeometricProgression(min, max, step);
            }
            if (progression_method.equals("add")) {
                return new ArithmeticProgression(min, max, step);
            }
            throw new IllegalArgumentException("Progression method for pvalue-list is either add or mul, but you specified " + progression_method);
        }
    }
}

