/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.di.ytilib;

import java.util.Arrays;
import ru.autosome.di.ytilib.WPCM;
import ru.autosome.perfectosape.backgroundModels.DiBackground;
import ru.autosome.perfectosape.backgroundModels.DiBackgroundModel;
import ru.autosome.perfectosape.calculations.HashOverflowException;
import ru.autosome.perfectosape.calculations.findPvalue.CanFindPvalue;
import ru.autosome.perfectosape.calculations.findPvalue.FindPvalueAPE;
import ru.autosome.perfectosape.motifModels.DiPWM;

public class PerfectosPvalue {
    private final FindPvalueAPE<DiPWM, DiBackgroundModel> calculator;

    public PerfectosPvalue(WPCM pwm, double[] background) {
        DiBackground backgroundModel = new DiBackground(Arrays.copyOfRange(background, 0, 16));
        double[][] newMatrix = new double[pwm.length()][16];
        double[][] oldMatrix = pwm.getMatrix();
        for (int i = 0; i < pwm.length(); ++i) {
            for (int l = 0; l < 16; ++l) {
                newMatrix[i][l] = oldMatrix[l][i];
            }
        }
        this.calculator = new FindPvalueAPE<DiPWM, DiBackground>(new DiPWM(newMatrix, null), backgroundModel, 10000.0, null);
    }

    public double PointPvalue(double threshold) {
        CanFindPvalue.PvalueInfo info = null;
        try {
            info = this.calculator.pvalueByThreshold(threshold);
        }
        catch (HashOverflowException e) {
            throw new RuntimeException("hash overflow during P-value evaluation");
        }
        return info.pvalue;
    }
}

