/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.assist;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.rank.Median;
import ru.autosome.assist.AMatrix;
import ru.autosome.assist.Occurrence;

public abstract class ASequence {
    public double weight;
    protected byte[] direct;
    protected byte[] revcomp;
    protected double[] hdirect;
    protected double[] hrevcomp;

    public byte[] direct() {
        return this.direct;
    }

    public byte[] revcomp() {
        return this.direct;
    }

    public int length() {
        return this.direct.length;
    }

    public double bestHit(AMatrix wpcm) {
        double max_score = -1.7976931348623157E308;
        for (int i = 0; i <= this.direct.length - wpcm.length; ++i) {
            double current_score = wpcm.score(this.direct, i);
            double revcomp_score = wpcm.score(this.revcomp, i);
            max_score = Math.max(max_score, Math.max(current_score, revcomp_score));
        }
        return max_score;
    }

    public void bestHits(AMatrix wpcm, List<Integer> prihit, List<Integer> revhit) {
        prihit.clear();
        revhit.clear();
        double best_hit = wpcm.hits(this.direct, this.revcomp, this.hdirect, this.hrevcomp);
        for (int i = 0; i <= this.direct.length - wpcm.length; ++i) {
            if (this.hdirect[i] >= best_hit) {
                prihit.add(i);
            }
            if (!(this.hrevcomp[i] >= best_hit)) continue;
            revhit.add(i);
        }
    }

    public void rebuild(AMatrix wpcm, List<Integer> prihits, List<Integer> revhits) {
        int j;
        double total_weight = this.weight / (double)(prihits.size() + revhits.size());
        for (Integer prihit : prihits) {
            j = 0;
            while (j < wpcm.length) {
                double[] dArray = wpcm.matrix[this.direct[prihit + j]];
                int n = j++;
                dArray[n] = dArray[n] + total_weight;
            }
        }
        for (Integer revhit : revhits) {
            j = 0;
            while (j < wpcm.length) {
                double[] dArray = wpcm.matrix[this.revcomp[revhit + j]];
                int n = j++;
                dArray[n] = dArray[n] + total_weight;
            }
        }
    }

    public abstract String word2str(byte[] var1, int var2, int var3);

    public List<Occurrence> gatherOccurrences(AMatrix pm, double threshold) {
        ArrayList<Occurrence> result = new ArrayList<Occurrence>();
        for (int i = 0; i <= this.direct.length - pm.length; ++i) {
            double direct_score = pm.score(this.direct, i);
            double revcomp_score = pm.score(this.revcomp, i);
            if (direct_score >= threshold) {
                result.add(new Occurrence(this.word2str(this.direct, i, pm.length), i, Strand.DIRECT, direct_score));
            }
            if (!(revcomp_score >= threshold)) continue;
            result.add(new Occurrence(this.word2str(this.revcomp, i, pm.length), this.revcomp.length - pm.length - i, Strand.REVCOMP, revcomp_score));
        }
        return result;
    }

    public boolean hasOccurrence(AMatrix pm, double threshold) {
        for (int i = 0; i <= this.direct.length - pm.length(); ++i) {
            double direct_score = pm.score(this.direct, i);
            double revcomp_score = pm.score(this.revcomp, i);
            if (direct_score >= threshold) {
                return true;
            }
            if (!(revcomp_score >= threshold)) continue;
            return true;
        }
        return false;
    }

    public abstract ASequence copy();

    public byte[] getRevcomp() {
        return this.revcomp;
    }

    public byte[] getDirect() {
        return this.direct;
    }

    public static double medianLength(ASequence[] sequences) {
        Median m = new Median();
        double[] lengths = new double[sequences.length];
        for (int i = 0; i < sequences.length; ++i) {
            lengths[i] = sequences[i].length();
        }
        return m.evaluate(lengths);
    }

    public static enum Strand {
        DIRECT,
        REVCOMP;

    }
}

